#pragma once

#include <QObject>

#include "variables.h"

class EtherCATSignalsSlots : public QObject
{
	Q_OBJECT
		
	private:
		VariablesInput& input;
		VariablesOutput& output;
		quint16 lastCommands = input.commands.getValue();
		
	public slots:
		void handler_generator_ready_get(bool enable);
		void handler_RF_enable_get(int intrasys_num, bool enable);
		void handler_DLL_enable_get(int intrasys_num, bool enable);
		void handler_PWM_settings_get(int intrasys_num, double frequency_hz, int duty_cycle);
		void handler_power_get(int intrasys_num, double power_dbm, double power_watt);
		void handler_PA_power_readings(int intrasys_num, double PA_power_fwd_dbm, double PA_power_rfl_dbm, double PA_s11_loss, double PA_power_fwd_watt, double PA_power_rfl_watt, double PA_s11_ratio);
		void handler_frequency_get(int intrasys_num, double frequency_mhz);
		void handler_SWP_measurement_get(int intrasys_num, QString SWP_raw_data);
		void handler_SWP_settings_get(int instrasys_num, double frequency_start, double frequency_stop, double frequency_step, double power_dbm, double power_watt);
		void handler_temperature_get(int intrasys_num, double temperature);
		void handler_error_get(int intrasys_num, int error, QStringList error_messages);
		void handler_datalogging_enable_get(bool enable);
		void handler_datalogging_storage_sufficient(bool enable);
		void handler_PSU_enable_combined_get(int intrasys_num, bool enable);
		void handler_PSU_IU_get(int intrasys_num, int psu_num, double voltage, double current, double power);
		void handler_PSU_dissipation_get(int intrasys_num, double dissipation);
		void handler_PSU_power_efficiency_get(int intrasys_num, double efficiency);
		void handler_SGx_communication_working_get(bool working);
		void handler_PSU_communication_working_get(bool working);
		void handler_get_phase(int intrasys_num, double phase_degrees);
		void handler_get_clock_source(int intrasys_num, int clock_source);
		void handler_get_PGB_phase(int intrasys_num, int pg_channel_num, double phase);
		
	signals:
		void signal_set_power_watt(int intrasys_num, double val);
		void signal_set_frequency(int intrasys_num, double val);
		void signal_set_SWP_frequency_start(int intrasys_num, double val);
		void signal_set_SWP_frequency_stop(int intrasys_num, double val);
		void signal_set_SWP_frequency_step(int intrasys_num, double val);
		void signal_set_SWP_power(int intrasys_num, double val);
		
		void signal_set_DLL_frequency_limit_lower(int intrasys_num, double val);
		void signal_set_DLL_frequency_limit_upper(int intrasys_num, double val);
		void signal_set_DLL_frequency_start(int intrasys_num, double val);
		void signal_set_DLL_frequency_step(int intrasys_num, double val);
		void signal_set_DLL_threshold(int intrasys_num, double val);
		void signal_set_DLL_delay(int intrasys_num, double val);
		
		void signal_set_PWM_duty_cycle(int intrasys_num, int val);
		
		void signal_set_phase(int intrasys_num, double val);
		void signal_set_clock_source(int intrasys_num, int val);
		
		void signal_set_PGB_phase(int intrasys_num, int PGB_channel_num, double val);
		
		// Command bits
		void signal_set_RF_enable(int intrasys_num, bool enable);
		void signal_execute_reset_SGx(int intrasys_num);
		void signal_execute_error_clear(int intrasys_num);
		void signal_execute_sweep(int intrasys_num, double freq_start, double freq_stop, double freq_step, double pow_dbm);
		void signal_set_DLL_enable(int intrasys_num, bool enable);
		void signal_set_PWM_enable(int intrasys_num, bool enable);
		void signal_set_power_control_mode(int intrasys_num, int mode);
		void signal_execute_reset_protection(int intrasys_num);
		void signal_PSU_interlock(bool enable);
		void signal_execute_restart_program();

	public:
		EtherCATSignalsSlots (VariablesInput& input, VariablesOutput& output, QObject *parent = nullptr);
};


class EtherCATSignalsSlots_1channel : public QObject
{
	Q_OBJECT

	private:
		VariablesInput_1channel& input;
		VariablesOutput_1channel& output;
		quint16 last_commands_set_bitmask = input.commands_set_bitmask.getValue();

	public slots:
		void handler_generator_ready_get(bool enable);
		void handler_RF_enable_get(int intrasys_num, bool enable);
		void handler_DLL_enable_get(int intrasys_num, bool enable);
		void handler_PWM_settings_get(int intrasys_num, double frequency_hz, int duty_cycle);
		void handler_power_get(int intrasys_num, double power_dbm, double power_watt);
		void handler_PA_power_readings(int intrasys_num, double PA_power_fwd_dbm, double PA_power_rfl_dbm, double PA_s11_loss, double PA_power_fwd_watt, double PA_power_rfl_watt, double PA_s11_ratio);
		void handler_frequency_get(int intrasys_num, double frequency_mhz);
		void handler_SWP_measurement_get(int intrasys_num, QString SWP_raw_data);
		void handler_SWP_settings_get(int instrasys_num, double frequency_start, double frequency_stop, double frequency_step, double power_dbm, double power_watt);
		void handler_temperature_get(int intrasys_num, double temperature);
		void handler_error_get(int intrasys_num, int error, QStringList error_messages);
		void handler_datalogging_enable_get(bool enable);
		void handler_datalogging_storage_sufficient(bool enable);
		void handler_PSU_enable_combined_get(int intrasys_num, bool enable);
		void handler_PSU_IU_get(int intrasys_num, int psu_num, double voltage, double current, double power);
		void handler_PSU_dissipation_get(int intrasys_num, double dissipation);
		void handler_PSU_power_efficiency_get(int intrasys_num, double efficiency);
		void handler_SGx_communication_working_get(bool working);
		void handler_PSU_communication_working_get(bool working);
		void handler_get_phase(int intrasys_num, double phase_degrees);
		void handler_get_clock_source(int intrasys_num, int clock_source);
//		void handler_get_PGB_phase(int intrasys_num, int pg_channel_num, double phase);

	signals:
		void signal_set_power_watt(int intrasys_num, double val);
		void signal_set_frequency(int intrasys_num, double val);
		void signal_set_SWP_frequency_start(int intrasys_num, double val);
		void signal_set_SWP_frequency_stop(int intrasys_num, double val);
		void signal_set_SWP_frequency_step(int intrasys_num, double val);
		void signal_set_SWP_power(int intrasys_num, double val);

		void signal_set_DLL_frequency_limit_lower(int intrasys_num, double val);
		void signal_set_DLL_frequency_limit_upper(int intrasys_num, double val);
		void signal_set_DLL_frequency_start(int intrasys_num, double val);
		void signal_set_DLL_frequency_step(int intrasys_num, double val);
		void signal_set_DLL_threshold(int intrasys_num, double val);
		void signal_set_DLL_delay(int intrasys_num, double val);

		void signal_set_PWM_duty_cycle(int intrasys_num, int val);

		void signal_set_phase(int intrasys_num, double val);
		void signal_set_clock_source(int intrasys_num, int val);

//		void signal_set_PGB_phase(int intrasys_num, int PGB_channel_num, double val);

		// Command bits
		void signal_set_RF_enable(int intrasys_num, bool enable);
		void signal_execute_reset_SGx(int intrasys_num);
		void signal_execute_error_clear(int intrasys_num);
		void signal_execute_sweep(int intrasys_num, double freq_start, double freq_stop, double freq_step, double pow_dbm);
		void signal_set_DLL_enable(int intrasys_num, bool enable);
		void signal_set_PWM_enable(int intrasys_num, bool enable);
		void signal_set_power_control_mode(int intrasys_num, int mode);
		void signal_execute_reset_protection(int intrasys_num);
		void signal_PSU_interlock(bool enable);
		void signal_execute_restart_program();

	public:
		EtherCATSignalsSlots_1channel (VariablesInput_1channel& input, VariablesOutput_1channel& output, QObject *parent = nullptr);
};


class EtherCATSignalsSlots_4channel : public QObject
{
	Q_OBJECT

	private:
		VariablesInput_4channel& input_4channel;
		VariablesOutput_4channel& output_4channel;

//		quint8 last_error_clear_bitmask = input_4channel.error_clear_bitmask.getValue();
		quint8 last_ERRC_SWP_execute_bitmask = input_4channel.ERRC_SWP_execute_bitmask.getValue();	//Error Clear (bit 1-4) + Sweep execute (bit 5-8)
		quint8 last_RFE_DLL_set_bitmask = input_4channel.RFE_DLL_set_bitmask.getValue();			//RF enable (bit 1-4) + DLL enable bitmask (bit 5-8)
		quint8 last_feedforward_enable_set_bitmask = input_4channel.feedforward_enable_set_bitmask.getValue();						//Autogain ON/OFF


	public slots:
		void handler_error_get(int intrasys_num, quint64 error, QStringList error_messages);
		void handler_power_control_mode_get(int intrasys_num, int mode);
		void handler_RF_enable_get(int intrasys_num, bool enable);
		void handler_DLL_enable_get(int intrasys_num, bool enable);
		void handler_frequency_get(int intrasys_num, double frequency_mhz);
		void handler_power_get(int intrasys_num, double power_dbm, double power_watt);
		void handler_PA_power_readings(int intrasys_num, double PA_power_fwd_dbm, double PA_power_rfl_dbm, double PA_s11_loss, double PA_power_fwd_watt, double PA_power_rfl_watt, double PA_s11_ratio);
//		void handler_get_phase(int intrasys_num, double phase_degrees);
		void handler_VGA_attenuation_get(int intrasys_num, double attenuation);
		void handler_IQMod_magnitude_get(int intrasys_num, double magnitude);
		void handler_SWP_measurement_get(int intrasys_num, QString SWP_raw_data);


	signals:
		void signal_set_frequency(int intrasys_num, double val);
		void signal_set_power_watt(int intrasys_num, double val);
//		void signal_set_phase(int intrasys_num, double val);

		void signal_set_VGA_attenuation(int intrasys_num, double attenuation);
		void signal_set_IQMod_magnitude(int intrasys_num, double magnitude);

		void signal_set_DLL_frequency_limit_lower(int intrasys_num, double val);
		void signal_set_DLL_frequency_limit_upper(int intrasys_num, double val);
		void signal_set_DLL_frequency_start(int intrasys_num, double val);
		void signal_set_DLL_frequency_step(int intrasys_num, double val);
		void signal_set_DLL_threshold(int intrasys_num, double val);
//		void signal_set_DLL_delay(int intrasys_num, double val);

		void signal_set_SWP_frequency_start(int intrasys_num, double val);
		void signal_set_SWP_frequency_stop(int intrasys_num, double val);
		void signal_set_SWP_frequency_step(int intrasys_num, double val);
		void signal_set_SWP_power(int intrasys_num, double val);

		// Command bits
		void signal_set_power_control_mode(int intrasys_num, int mode);
		void signal_set_RF_enable(int intrasys_num, bool enable);
		void signal_set_DLL_enable(int intrasys_num, bool enable);
		void signal_execute_error_clear(int intrasys_num);
		void signal_execute_sweep(int intrasys_num, double freq_start, double freq_stop, double freq_step, double pow_dbm);


public:
		EtherCATSignalsSlots_4channel (VariablesInput_4channel& input, VariablesOutput_4channel& output, QObject *parent = nullptr);
};
